/////////////////////////////////////////////////////////////
// CINEMA SDK : ANIMATION  															   //
/////////////////////////////////////////////////////////////
// VERSION    : CINEMA 4D																	 //
/////////////////////////////////////////////////////////////
// (c) 1989-2002 MAXON Computer GmbH, all rights reserved	 //
/////////////////////////////////////////////////////////////

#ifndef __C4DCOFFEE_H
#define __C4DCOFFEE_H

class String;
class Coffee;
class Value;
class GeData;

Coffee* GeCoffeeAlloc();
void GeCoffeeFree(Coffee* &cof);

Bool GeCoffeeCompileString(Coffee* cof, const String& src);
Bool GeCoffeeCompileFile(Coffee* cof, const Filename& file);

VALUE* GeCoffeeAddGlobalSymbol(Coffee* cof, const String& name);
VALUE* GeCoffeeFindGlobalSymbol(Coffee* cof, const String& name);

Bool GeCoffeeExecute(Coffee* cof, VALUE* func, GeData* retval = NULL, GeData* arg1 = NULL, GeData* arg2 = NULL, GeData* arg3 = NULL);
Bool GeCoffeeGeData2Value(Coffee* cof, const GeData& src, VALUE* dest);
Bool GeCoffeeValue2GeData(Coffee* cof, VALUE *src, GeData* dest);
Bool GeCoffeeGetLastError(Coffee* cof, String *err_string, LONG *err_line, LONG *err_pos);

Bool CoffeeEditor_Open(BaseList2D *obj,CoffeeEditorCallback *callback);

#endif
